/*
 * Decompiled with CFR 0.152.
 */
package yeti;

import java.text.ParseException;
import yeti.JSONObj;
import yeti.lang.Core;
import yeti.lang.Hash;
import yeti.lang.MList;

final class JSONParser {
    private static final int ARRAY_FST = 1;
    private static final int ARRAY = 2;
    private static final int ARRAY_SEP = 3;
    private static final int OBJ_FST = 4;
    private static final int OBJ = 5;
    private static final int PAIR = 6;
    private static final int OBJ_SEP = 7;
    private final JSONParser prev;
    private final MList result;
    private final int state;

    private JSONParser(JSONParser jSONParser, MList mList, int n) {
        this.prev = jSONParser;
        this.result = mList;
        this.state = n;
    }

    static Object parse(char[] cArray, int n, int n2) throws ParseException {
        JSONParser jSONParser = new JSONParser(null, new MList(), 0);
        jSONParser.result.reserve(1);
        for (n = JSONParser.parse(cArray, n, n2, jSONParser); n >= 0 && n < n2 && cArray[n] <= ' '; ++n) {
        }
        if (n != n2) {
            n = Math.abs(n);
            throw new ParseException("Parse error at " + n, n);
        }
        return jSONParser.result.length() <= 0L ? null : jSONParser.result.get(0);
    }

    private static int parse(char[] cArray, int n, int n2, JSONParser jSONParser) {
        MList mList = null;
        int n3 = 0;
        block32: while (true) {
            if (n < n2 && cArray[n] <= ' ') {
                ++n;
                continue;
            }
            if (n >= n2) {
                return -n;
            }
            char c2 = cArray[n];
            ++n;
            block2 : switch (n3) {
                case 0: {
                    switch (c2) {
                        case '[': {
                            n3 = 1;
                            mList = new MList();
                            jSONParser.result.add(mList);
                            continue block32;
                        }
                        case '{': {
                            n3 = 4;
                            mList = new MList();
                            continue block32;
                        }
                        case '\"': {
                            StringBuilder stringBuilder = null;
                            int n4 = n;
                            while (n < n2) {
                                block17 : switch (cArray[n]) {
                                    case '\"': {
                                        String string2 = new String(cArray, n4, n - n4);
                                        jSONParser.result.add(stringBuilder == null ? string2 : stringBuilder.append(string2).toString());
                                        ++n;
                                        break block2;
                                    }
                                    case '\\': {
                                        if (stringBuilder == null) {
                                            stringBuilder = new StringBuilder();
                                        }
                                        stringBuilder.append(new String(cArray, n4, n - n4));
                                        if (++n < n2) {
                                            n4 = n + 1;
                                            switch (cArray[n]) {
                                                case '\"': 
                                                case '/': 
                                                case '\\': {
                                                    n4 = n;
                                                    break block17;
                                                }
                                                case 'b': {
                                                    stringBuilder.append('\b');
                                                    break block17;
                                                }
                                                case 'f': {
                                                    stringBuilder.append('\f');
                                                    break block17;
                                                }
                                                case 'n': {
                                                    stringBuilder.append('\n');
                                                    break block17;
                                                }
                                                case 'r': {
                                                    stringBuilder.append('\r');
                                                    break block17;
                                                }
                                                case 't': {
                                                    stringBuilder.append('\t');
                                                    break block17;
                                                }
                                                case 'u': {
                                                    try {
                                                        stringBuilder.append(Character.toChars(Integer.parseInt(new String(cArray, n + 1, 4), 16)));
                                                    }
                                                    catch (Exception exception) {
                                                        return -n;
                                                    }
                                                    n4 = (n += 4) + 1;
                                                    break block17;
                                                }
                                            }
                                        }
                                        return -n;
                                    }
                                }
                                ++n;
                            }
                            return -n;
                        }
                    }
                    int n5 = --n;
                    while (n < n2 && ((c2 = cArray[n]) >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == '.' || c2 == '+' || c2 == '-')) {
                        ++n;
                    }
                    String string3 = new String(cArray, n5, n - n5);
                    if (string3.equals("null")) {
                        jSONParser.result.add(null);
                        break;
                    }
                    if (string3.equals("false")) {
                        jSONParser.result.add(Boolean.FALSE);
                        break;
                    }
                    if (string3.equals("true")) {
                        jSONParser.result.add(Boolean.TRUE);
                        break;
                    }
                    try {
                        jSONParser.result.add(Core.parseNum(string3));
                        break;
                    }
                    catch (Exception exception) {
                        return -n;
                    }
                }
                case 1: {
                    if (c2 == ']') break;
                }
                case 2: {
                    jSONParser = new JSONParser(jSONParser, mList, 3);
                    n3 = 0;
                    --n;
                    continue block32;
                }
                case 3: {
                    if (c2 == ',') {
                        n3 = 2;
                        continue block32;
                    }
                    if (c2 == ']') break;
                    return -n;
                }
                case 4: {
                    if (c2 == '}') {
                        jSONParser.result.add(new JSONObj(new Hash()));
                        break;
                    }
                }
                case 5: {
                    if (c2 != '\"') {
                        return -n;
                    }
                    jSONParser = new JSONParser(jSONParser, mList, 6);
                    n3 = 0;
                    --n;
                    continue block32;
                }
                case 6: {
                    if (c2 != ':') {
                        return -n;
                    }
                    jSONParser = new JSONParser(jSONParser, mList, 7);
                    n3 = 0;
                    continue block32;
                }
                case 7: {
                    if (c2 == ',') {
                        n3 = 5;
                        continue block32;
                    }
                    if (c2 != '}') {
                        return -n;
                    }
                    int n6 = (int)mList.length();
                    Hash hash2 = new Hash(n6 * 3 / 2 + 1);
                    for (int i = 0; i < n6; i += 2) {
                        hash2.put(mList.get(i), mList.get(i + 1));
                    }
                    jSONParser.result.add(new JSONObj(hash2));
                }
            }
            if (jSONParser.prev == null) {
                return n;
            }
            mList = jSONParser.result;
            n3 = jSONParser.state;
            jSONParser = jSONParser.prev;
        }
    }
}

