/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.io.Serializable;
import java.util.Arrays;
import yeti.lang.AIter;
import yeti.lang.AList;
import yeti.lang.Core;
import yeti.lang.Fun;
import yeti.lang.IntNum;
import yeti.lang.MList;
import yeti.lang.Num;

abstract class AMList
extends AList
implements Serializable {
    int start;

    AMList() {
    }

    abstract int _size();

    abstract Object[] array();

    @Override
    public long length() {
        int n = this._size() - this.start;
        return n > 0 ? (long)n : 0L;
    }

    @Override
    public Object copy() {
        Object[] objectArray = new Object[this._size()];
        System.arraycopy(this.array(), this.start, objectArray, 0, objectArray.length);
        return new MList(objectArray);
    }

    public int hashCode() {
        int n = 1;
        Object[] objectArray = this.array();
        int n2 = this._size();
        for (int i = this.start; i < n2; ++i) {
            Object object = objectArray[i];
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return this._size() <= this.start;
        }
        if (object instanceof AMList) {
            AMList aMList = (AMList)object;
            int n = this._size();
            if (n - this.start != aMList._size() - aMList.start) {
                return false;
            }
            Object[] objectArray = this.array();
            Object[] objectArray2 = aMList.array();
            int n2 = this.start;
            int n3 = aMList.start;
            while (n2 < n) {
                Object object2 = objectArray[n2];
                Object object3 = objectArray2[n3];
                if (!(object2 == object3 || object2 != null && object2.equals(object3))) {
                    return false;
                }
                ++n2;
                ++n3;
            }
            return true;
        }
        if (!(object instanceof AList)) {
            return false;
        }
        Object[] objectArray = this.array();
        AIter aIter = (AList)object;
        int n = this._size();
        for (int i = this.start; i < n; ++i) {
            Object object4;
            Object object5;
            if (aIter == null || (object5 = objectArray[i]) != (object4 = aIter.first()) && (object5 == null || !object5.equals(object4))) {
                return false;
            }
            aIter = aIter.next();
        }
        return aIter == null;
    }

    @Override
    public String toString() {
        Object[] objectArray = this.array();
        StringBuilder stringBuilder = new StringBuilder("[");
        int n = this._size();
        for (int i = this.start; i < n; ++i) {
            if (i > this.start) {
                stringBuilder.append(',');
            }
            stringBuilder.append(Core.show(objectArray[i]));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void forEach(Object object) {
        Fun fun = (Fun)object;
        Object[] objectArray = this.array();
        int n = this._size();
        for (int i = this.start; i < n; ++i) {
            fun.apply(objectArray[i]);
        }
    }

    @Override
    public Object fold(Fun fun, Object object) {
        Object[] objectArray = this.array();
        int n = this._size();
        for (int i = this.start; i < n; ++i) {
            object = fun.apply(object, objectArray[i]);
        }
        return object;
    }

    @Override
    public Num index(Object object) {
        Object[] objectArray = this.array();
        int n = this._size();
        if (object == null) {
            for (int i = this.start; i < n; ++i) {
                if (objectArray[i] != null) continue;
                return new IntNum(i - this.start);
            }
            return null;
        }
        for (int i = this.start; i < n; ++i) {
            if (!object.equals(objectArray[i])) continue;
            return new IntNum(i - this.start);
        }
        return null;
    }

    @Override
    public AList map(Fun fun) {
        int n = this._size();
        if (this.start >= n) {
            return null;
        }
        Object[] objectArray = this.array();
        Object[] objectArray2 = new Object[n - this.start];
        for (int i = this.start; i < n; ++i) {
            objectArray2[i - this.start] = fun.apply(objectArray[i]);
        }
        return new MList(objectArray2);
    }

    @Override
    public AList smap(Fun fun) {
        return this.map(fun);
    }

    public int compareTo(Object object) {
        Object[] objectArray = this.array();
        int n = this._size();
        int n2 = this.start;
        if (!(object instanceof AMList)) {
            AIter aIter;
            for (aIter = (AIter)object; n2 < n && aIter != null; aIter = aIter.next(), ++n2) {
                object = objectArray[n2];
                if (object != null) {
                    int n3 = ((Comparable)object).compareTo(aIter.first());
                    if (n3 == 0) continue;
                    return n3;
                }
                if (aIter.first() == null) continue;
                return -1;
            }
            return aIter != null ? -1 : (n2 < n ? 1 : 0);
        }
        AMList aMList = (AMList)object;
        Object[] objectArray2 = aMList.array();
        int n4 = aMList._size();
        for (int i = aMList.start; n2 < n && i < n4; ++n2, ++i) {
            object = objectArray[n2];
            if (object != null) {
                int n5 = ((Comparable)object).compareTo(objectArray2[i]);
                if (n5 == 0) continue;
                return n5;
            }
            if (objectArray2[i] == null) continue;
            return -1;
        }
        return n < n4 ? -1 : (n > n4 ? 1 : 0);
    }

    @Override
    public AList reverse() {
        Object[] objectArray = this.array();
        int n = this._size();
        if (n <= this.start) {
            return null;
        }
        Object[] objectArray2 = new Object[n - this.start];
        --n;
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = objectArray[n - i];
        }
        return new MList(objectArray2);
    }

    @Override
    public AList sort() {
        int n = this._size() - this.start;
        if (n <= 0) {
            return null;
        }
        Object[] objectArray = new Object[n];
        System.arraycopy(this.array(), this.start, objectArray, 0, n);
        Arrays.sort(objectArray);
        return new MList(objectArray);
    }

    @Override
    public AList sort(Fun fun) {
        int n = this._size() - this.start;
        if (n <= 0) {
            return null;
        }
        Object[] objectArray = new Object[n];
        System.arraycopy(this.array(), this.start, objectArray, 0, n);
        return new MList(objectArray).asort(fun);
    }
}

