/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import yeti.lang.FloatNum;
import yeti.lang.IntNum;
import yeti.lang.Num;
import yeti.lang.RatNum;

public final class BigNum
extends Num {
    private final BigInteger v;

    public BigNum(long l2) {
        this.v = BigInteger.valueOf(l2);
    }

    public BigNum(BigInteger bigInteger) {
        this.v = bigInteger;
    }

    public BigNum(String string2, int n) {
        this.v = new BigInteger(string2, n);
    }

    @Override
    public Num add(Num num) {
        return num.add(this.v);
    }

    @Override
    public Num add(RatNum ratNum) {
        return ratNum.add(this.v);
    }

    @Override
    public Num add(BigInteger bigInteger) {
        return new BigNum(bigInteger.add(this.v));
    }

    @Override
    public Num add(long l2) {
        return new BigNum(this.v.add(BigInteger.valueOf(l2)));
    }

    @Override
    public Num mul(Num num) {
        return num.mul(this.v);
    }

    @Override
    public Num mul(long l2) {
        return new BigNum(this.v.multiply(BigInteger.valueOf(l2)));
    }

    @Override
    public Num mul(RatNum ratNum) {
        return ratNum.mul(this.v);
    }

    @Override
    public Num mul(BigInteger bigInteger) {
        return new BigNum(bigInteger.multiply(this.v));
    }

    @Override
    public Num div(Num num) {
        return new FloatNum(this.v.doubleValue() / num.doubleValue());
    }

    @Override
    public Num div(long l2) {
        return new FloatNum(this.v.doubleValue() / (double)l2);
    }

    @Override
    public Num divFrom(long l2) {
        return new FloatNum((double)l2 / this.v.doubleValue());
    }

    @Override
    public Num divFrom(RatNum ratNum) {
        return new FloatNum(ratNum.doubleValue() / this.v.doubleValue());
    }

    @Override
    public Num intDiv(Num num) {
        return num.intDivFrom(this.v);
    }

    @Override
    public Num intDiv(int n) {
        return new BigNum(this.v.divide(BigInteger.valueOf(n)));
    }

    @Override
    public Num intDivFrom(BigInteger bigInteger) {
        return new BigNum(bigInteger.divide(this.v));
    }

    @Override
    public Num intDivFrom(long l2) {
        return new IntNum(BigInteger.valueOf(l2).divide(this.v).longValue());
    }

    @Override
    public Num rem(Num num) {
        return num.remFrom(this.v);
    }

    @Override
    public Num rem(int n) {
        return new IntNum(this.v.remainder(BigInteger.valueOf(n)).longValue());
    }

    @Override
    public Num remFrom(BigInteger bigInteger) {
        return new BigNum(bigInteger.remainder(this.v));
    }

    @Override
    public Num remFrom(long l2) {
        return new IntNum(BigInteger.valueOf(l2).remainder(this.v).longValue());
    }

    @Override
    public Num sub(Num num) {
        return num.subFrom(this.v);
    }

    @Override
    public Num sub(long l2) {
        return new BigNum(this.v.subtract(BigInteger.valueOf(l2)));
    }

    @Override
    public Num subFrom(long l2) {
        return new BigNum(BigInteger.valueOf(l2).subtract(this.v));
    }

    @Override
    public Num subFrom(RatNum ratNum) {
        return new FloatNum(ratNum.doubleValue() - this.v.doubleValue());
    }

    @Override
    public Num subFrom(BigInteger bigInteger) {
        return new BigNum(bigInteger.subtract(this.v));
    }

    @Override
    public Num shl(int n) {
        return new BigNum(this.v.shiftLeft(n));
    }

    @Override
    public Num and(Num num) {
        return num.and(this.v);
    }

    @Override
    public Num and(BigInteger bigInteger) {
        return new BigNum(this.v.and(bigInteger));
    }

    @Override
    public Num or(Num num) {
        return new BigNum(this.v.or(num.toBigInteger()));
    }

    @Override
    public Num or(long l2) {
        return new BigNum(this.v.or(BigInteger.valueOf(l2)));
    }

    @Override
    public Num xor(Num num) {
        return new BigNum(this.v.xor(num.toBigInteger()));
    }

    @Override
    public Num xor(long l2) {
        return new BigNum(this.v.xor(BigInteger.valueOf(l2)));
    }

    @Override
    public byte byteValue() {
        return this.v.byteValue();
    }

    @Override
    public short shortValue() {
        return this.v.shortValue();
    }

    @Override
    public int intValue() {
        return this.v.intValue();
    }

    @Override
    public long longValue() {
        return this.v.longValue();
    }

    @Override
    public float floatValue() {
        return this.v.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.v.doubleValue();
    }

    @Override
    public BigInteger toBigInteger() {
        return this.v;
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.v);
    }

    public int compareTo(Object object) {
        return ((Num)object).rCompare(this.v);
    }

    @Override
    public int rCompare(long l2) {
        return BigInteger.valueOf(l2).compareTo(this.v);
    }

    @Override
    public int rCompare(RatNum ratNum) {
        return -ratNum.rCompare(this.v);
    }

    @Override
    public int rCompare(BigInteger bigInteger) {
        return bigInteger.compareTo(this.v);
    }

    public String toString() {
        return this.v.toString();
    }

    @Override
    public String toString(int n, int n2) {
        return this.v.toString(n);
    }

    public int hashCode() {
        if (this.v.bitLength() > 63) {
            return this.v.hashCode();
        }
        long l2 = this.v.longValue();
        return (int)(l2 ^ l2 >>> 32);
    }
}

