/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.io.IOException;
import java.io.OutputStream;
import yeti.lang.AIter;
import yeti.lang.AList;
import yeti.lang.LList;

final class ConcatList
extends LList {
    private boolean mappedRest;
    private AIter src;
    private AList tail;

    public ConcatList(AIter aIter, AList aList) {
        super(aIter.first(), null);
        this.src = aIter;
        this.tail = aList;
    }

    @Override
    public synchronized AIter next() {
        if (!this.mappedRest) {
            AIter aIter = this.src.next();
            if (aIter != null) {
                this.tail = new ConcatList(aIter, this.tail);
            }
            this.src = null;
            this.mappedRest = true;
        }
        return this.tail;
    }

    @Override
    public synchronized AList rest() {
        if (!this.mappedRest) {
            AIter aIter = this.src.next();
            if (aIter != null) {
                this.tail = new ConcatList(aIter, this.tail);
            }
            this.src = null;
            this.mappedRest = true;
        }
        return this.tail;
    }

    @Override
    synchronized AIter write(OutputStream outputStream) throws IOException {
        if (this.mappedRest) {
            return super.write(outputStream);
        }
        for (AIter aIter = this.src.dup(); aIter != null; aIter = aIter.write(outputStream)) {
        }
        return this.tail.write(outputStream);
    }
}

