/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.io.IOException;
import java.io.OutputStream;
import yeti.lang.AIter;
import yeti.lang.AList;
import yeti.lang.LList;

final class ConcatLists
extends LList {
    private AList rest;
    private AIter src;
    private AIter tail;

    public ConcatLists(AIter aIter, AIter aIter2) {
        super(aIter.first(), null);
        this.src = aIter;
        this.tail = aIter2;
    }

    @Override
    public synchronized AList rest() {
        if (this.src != null) {
            AIter aIter = this.src.next();
            this.src = null;
            this.rest = aIter == null ? ConcatLists.concat(this.tail) : new ConcatLists(aIter, this.tail);
            this.tail = null;
        }
        return this.rest;
    }

    @Override
    synchronized AIter write(OutputStream outputStream) throws IOException {
        AIter aIter;
        if (this.src == null) {
            return super.write(outputStream);
        }
        for (aIter = this.src.dup(); aIter != null; aIter = aIter.write(outputStream)) {
        }
        if (this.tail != null) {
            AIter aIter2 = this.tail.dup();
            do {
                for (aIter = (AIter)aIter2.first(); aIter != null; aIter = aIter.write(outputStream)) {
                }
            } while ((aIter2 = aIter2.next()) != null);
        }
        return null;
    }

    public static AList concat(AIter aIter) {
        while (aIter != null) {
            AList aList = (AList)aIter.first();
            aIter = aIter.next();
            if (aList == null || aList.isEmpty()) continue;
            return aIter == null ? aList : new ConcatLists(aList, aIter);
        }
        return null;
    }
}

