/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.math.BigInteger;
import yeti.lang.IntNum;
import yeti.lang.Num;
import yeti.lang.RatNum;

public final class FloatNum
extends Num {
    private final double v;

    public FloatNum(double d2) {
        this.v = d2;
    }

    @Override
    public Num add(Num num) {
        return new FloatNum(this.v + num.doubleValue());
    }

    @Override
    public Num add(long l2) {
        return new FloatNum(this.v + (double)l2);
    }

    @Override
    public Num add(RatNum ratNum) {
        return new FloatNum(this.v + ratNum.doubleValue());
    }

    @Override
    public Num add(BigInteger bigInteger) {
        return new FloatNum(this.v + bigInteger.doubleValue());
    }

    @Override
    public Num mul(Num num) {
        return new FloatNum(this.v * num.doubleValue());
    }

    @Override
    public Num mul(long l2) {
        return new FloatNum(this.v * (double)l2);
    }

    @Override
    public Num mul(RatNum ratNum) {
        return new FloatNum(this.v * ratNum.doubleValue());
    }

    @Override
    public Num mul(BigInteger bigInteger) {
        return new FloatNum(this.v * bigInteger.doubleValue());
    }

    @Override
    public Num div(Num num) {
        return new FloatNum(this.v / num.doubleValue());
    }

    @Override
    public Num div(long l2) {
        return new FloatNum(this.v / (double)l2);
    }

    @Override
    public Num divFrom(long l2) {
        return new FloatNum((double)l2 / this.v);
    }

    @Override
    public Num divFrom(RatNum ratNum) {
        return new FloatNum(ratNum.doubleValue() / this.v);
    }

    @Override
    public Num intDiv(Num num) {
        double d2 = (this.v >= 0.0 ? Math.floor(this.v) : Math.ceil(this.v)) / num.doubleValue();
        return d2 > 2.147483647E9 || d2 < -2.147483647E9 ? new FloatNum(d2 >= 0.0 ? Math.floor(d2) : Math.ceil(d2)) : new IntNum((long)d2);
    }

    @Override
    public Num intDiv(int n) {
        double d2 = (this.v >= 0.0 ? Math.floor(this.v) : Math.ceil(this.v)) / (double)n;
        return d2 > 2.147483647E9 || d2 < -2.147483647E9 ? new FloatNum(d2 >= 0.0 ? Math.floor(d2) : Math.ceil(d2)) : new IntNum((long)d2);
    }

    @Override
    public Num intDivFrom(long l2) {
        return new IntNum((long)((double)l2 / (this.v >= 0.0 ? Math.floor(this.v) : Math.ceil(this.v))));
    }

    @Override
    public Num intDivFrom(BigInteger bigInteger) {
        double d2 = bigInteger.doubleValue() / (this.v >= 0.0 ? Math.floor(this.v) : Math.ceil(this.v));
        return d2 > 2.147483647E9 || d2 < -2.147483647E9 ? new FloatNum(d2 >= 0.0 ? Math.floor(d2) : Math.ceil(d2)) : new IntNum((long)d2);
    }

    @Override
    public Num rem(Num num) {
        return new IntNum((long)this.v % num.longValue());
    }

    @Override
    public Num rem(int n) {
        return new IntNum((long)this.v % (long)n);
    }

    @Override
    public Num remFrom(long l2) {
        return new IntNum(l2 % (long)this.v);
    }

    @Override
    public Num remFrom(BigInteger bigInteger) {
        double d2 = bigInteger.doubleValue() % (this.v >= 0.0 ? Math.floor(this.v) : Math.ceil(this.v));
        return d2 > 2.147483647E9 || d2 < -2.147483647E9 ? new FloatNum(d2 >= 0.0 ? Math.floor(d2) : Math.ceil(d2)) : new IntNum((long)d2);
    }

    @Override
    public Num sub(Num num) {
        return new FloatNum(this.v - num.doubleValue());
    }

    @Override
    public Num sub(long l2) {
        return new FloatNum(this.v - (double)l2);
    }

    @Override
    public Num subFrom(long l2) {
        return new FloatNum((double)l2 - this.v);
    }

    @Override
    public Num subFrom(RatNum ratNum) {
        return new FloatNum(ratNum.doubleValue() - this.v);
    }

    @Override
    public Num subFrom(BigInteger bigInteger) {
        return new FloatNum(bigInteger.doubleValue() - this.v);
    }

    @Override
    public Num and(Num num) {
        return new IntNum(num.longValue() & (long)this.v);
    }

    @Override
    public Num and(BigInteger bigInteger) {
        return new IntNum(bigInteger.longValue() & (long)this.v);
    }

    @Override
    public Num or(Num num) {
        return num.or((long)this.v);
    }

    @Override
    public Num or(long l2) {
        return new IntNum(l2 | (long)this.v);
    }

    @Override
    public Num xor(Num num) {
        return num.xor((long)this.v);
    }

    @Override
    public Num xor(long l2) {
        return new IntNum(l2 ^ (long)this.v);
    }

    @Override
    public byte byteValue() {
        return (byte)this.v;
    }

    @Override
    public short shortValue() {
        return (short)this.v;
    }

    @Override
    public int intValue() {
        return (int)this.v;
    }

    @Override
    public long longValue() {
        return (long)this.v;
    }

    @Override
    public float floatValue() {
        return (float)this.v;
    }

    @Override
    public double doubleValue() {
        return this.v;
    }

    public int compareTo(Object object) {
        double d2 = ((Number)object).doubleValue();
        return this.v < d2 ? -1 : (this.v > d2 ? 1 : 0);
    }

    @Override
    public int rCompare(long l2) {
        return this.v < (double)l2 ? 1 : (this.v > (double)l2 ? -1 : 0);
    }

    @Override
    public int rCompare(RatNum ratNum) {
        double d2 = ratNum.doubleValue();
        return this.v < d2 ? 1 : (this.v > d2 ? -1 : 0);
    }

    @Override
    public int rCompare(BigInteger bigInteger) {
        double d2 = bigInteger.doubleValue();
        return this.v < d2 ? 1 : (this.v > d2 ? -1 : 0);
    }

    public String toString() {
        return Double.toString(this.v);
    }

    public int hashCode() {
        long l2 = (long)this.v;
        long l3 = Double.doubleToLongBits(this.v - (double)l2);
        if (l3 != Long.MIN_VALUE) {
            l2 ^= l3;
        }
        return (int)(l2 ^ l2 >>> 32);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Num && this.v == ((Num)object).doubleValue();
    }
}

