/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import yeti.lang.AIter;
import yeti.lang.AList;
import yeti.lang.AMList;
import yeti.lang.ByKey;
import yeti.lang.Core;
import yeti.lang.EmptyArrayException;
import yeti.lang.Fun;
import yeti.lang.ListRange;
import yeti.lang.NoSuchKeyException;

public class MList
extends AMList
implements ByKey {
    private static final Object[] EMPTY = new Object[0];
    private Object[] array;
    private int size;

    public MList() {
        this.array = EMPTY;
    }

    public MList(Object[] objectArray) {
        this.array = objectArray;
        this.size = objectArray.length;
    }

    public MList(AIter aIter) {
        if (aIter == null || aIter.isEmpty()) {
            this.array = EMPTY;
        } else {
            this.array = new Object[10];
            while (aIter != null) {
                this.add(aIter.first());
                aIter = aIter.next();
            }
        }
    }

    public void reserve(int n) {
        if (n > this.array.length) {
            Object[] objectArray = new Object[n];
            System.arraycopy(this.array, 0, objectArray, 0, this.size);
            this.array = objectArray;
        }
    }

    public void add(Object object) {
        if (this.size >= this.array.length) {
            Object[] objectArray = new Object[this.size == 0 ? 10 : this.size * 3 / 2 + 1];
            System.arraycopy(this.array, 0, objectArray, 0, this.array.length);
            this.array = objectArray;
        }
        this.array[this.size++] = object;
    }

    public Object shift() {
        if (this.start >= this.size) {
            throw new EmptyArrayException("No first element in empty array");
        }
        return this.array[this.start++];
    }

    public Object pop() {
        if (this.start >= this.size) {
            throw new EmptyArrayException("Cannot pop from an empty array");
        }
        return this.array[--this.size];
    }

    public void clear() {
        this.size = 0;
        this.start = 0;
    }

    @Override
    public Object first() {
        if (this.start >= this.size) {
            throw new EmptyArrayException("No first element in empty array");
        }
        return this.array[this.start];
    }

    @Override
    public AList rest() {
        int n = this.start + 1;
        return n < this.size ? new SubList(n) : null;
    }

    @Override
    public AIter next() {
        int n = this.start + 1;
        return n < this.size ? new Iter(n) : null;
    }

    @Override
    public boolean containsKey(Object object) {
        int n = ((Number)object).intValue();
        return n >= 0 && n + this.start < this.size;
    }

    @Override
    public Object vget(Object object) {
        int n = ((Number)object).intValue();
        if (n < 0) {
            throw new NoSuchKeyException(n, this.size - this.start);
        }
        if ((n += this.start) >= this.size) {
            throw new NoSuchKeyException(n - this.start, this.size - this.start);
        }
        return this.array[n];
    }

    public Object get(int n) {
        int n2;
        if (n < 0 || (n2 = n + this.start) >= this.size) {
            throw new NoSuchKeyException(n, this.size - this.start);
        }
        return this.array[n2];
    }

    @Override
    public Object put(Object object, Object object2) {
        int n = ((Number)object).intValue();
        if (n < 0) {
            throw new NoSuchKeyException(n, this.size - this.start);
        }
        if ((n += this.start) >= this.size) {
            throw new NoSuchKeyException(n - this.start, this.size - this.start);
        }
        this.array[n] = object2;
        return null;
    }

    @Override
    public Object remove(Object object) {
        int n;
        int n2 = ((Number)object).intValue();
        if (n2 < 0) {
            throw new NoSuchKeyException(n2, this.size - this.start);
        }
        if ((n2 += this.start) >= this.size) {
            throw new NoSuchKeyException(n2 - this.start, this.size - this.start);
        }
        if ((n = --this.size - n2) > 0) {
            System.arraycopy(this.array, n2 + 1, this.array, n2, n);
        }
        return null;
    }

    private void removeRange(ListRange listRange) {
        int n;
        int n2 = listRange.first.intValue();
        int n3 = listRange.last.intValue();
        if (listRange.inc < 0) {
            n = n2;
            n2 = n3;
            n3 = n;
        }
        n = this.size - this.start;
        if (n2 <= n3) {
            if (n2 < 0 || n2 >= n) {
                throw new NoSuchKeyException(n2, n);
            }
            if (n3 < 0 || n3 >= n) {
                throw new NoSuchKeyException(n3, n);
            }
            if (++n3 < n) {
                System.arraycopy(this.array, n3 + this.start, this.array, n2 + this.start, n - n3);
            }
            this.size -= n3 - n2;
        }
    }

    @Override
    public void removeAll(AList aList) {
        AList aList2;
        if (aList instanceof ListRange) {
            aList2 = (ListRange)aList;
            if (((ListRange)aList2).rest == null) {
                this.removeRange((ListRange)aList2);
                return;
            }
        }
        if (aList == null || aList.isEmpty()) {
            return;
        }
        aList2 = new MList();
        while (aList != null) {
            ((MList)aList2).add(aList);
            if (aList instanceof ListRange) {
                aList = ((ListRange)aList).rest;
                continue;
            }
            aList = aList.rest();
        }
        Object[] objectArray = ((MList)aList2).asort().array;
        Object object = null;
        int n = ((MList)aList2).size;
        while (--n >= 0) {
            if (objectArray[n] instanceof ListRange) {
                this.removeRange((ListRange)objectArray[n]);
                continue;
            }
            Object object2 = ((AList)objectArray[n]).first();
            if (object2.equals(object)) continue;
            this.remove(object2);
            object = object2;
        }
    }

    public MList copy(int n, int n2) {
        int n3 = this.size - this.start;
        if (n < 0 || n > n3) {
            throw new NoSuchKeyException(n, n3);
        }
        if (n2 > n3) {
            throw new NoSuchKeyException("Copy range " + n + " to " + n2 + " exceeds array length " + n3);
        }
        if (n >= n2) {
            return new MList();
        }
        Object[] objectArray = new Object[n2 - n];
        System.arraycopy(this.array, this.start + n, objectArray, 0, objectArray.length);
        return new MList(objectArray);
    }

    @Override
    public AList take(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        n += this.start;
        if (n2 < 0) {
            return n < this.size ? (n == this.start ? this : new SubList(n)) : null;
        }
        if ((n2 += this.start) > this.size) {
            n2 = this.size;
        }
        MList mList = new MList(this.array);
        mList.start = n;
        mList.size = n2;
        return mList;
    }

    @Override
    public AList find(Fun fun) {
        int n = this.size;
        for (int i = this.start; i < n; ++i) {
            if (fun.apply(this.array[i]) != Boolean.TRUE) continue;
            return new SubList(i);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.start >= this.size;
    }

    @Override
    final int _size() {
        return this.size;
    }

    @Override
    final Object[] array() {
        return this.array;
    }

    final MList asort() {
        Arrays.sort(this.array, this.start, this.size);
        return this;
    }

    private static void sort(Object[] objectArray, Object[] objectArray2, int n, int n2, Fun fun) {
        int n3 = (n + n2) / 2;
        if (n3 - n > 1) {
            MList.sort(objectArray2, objectArray, n, n3, fun);
        }
        if (n2 - n3 > 1) {
            MList.sort(objectArray2, objectArray, n3, n2, fun);
        }
        int n4 = n;
        int n5 = n3;
        while (n4 < n3 && n5 < n2) {
            objectArray[n] = fun.apply(objectArray2[n4], objectArray2[n5]) == Boolean.TRUE ? objectArray2[n4++] : objectArray2[n5++];
            ++n;
        }
        if (n4 < n3) {
            System.arraycopy(objectArray2, n4, objectArray, n, n3 - n4);
        } else if (n5 < n2) {
            System.arraycopy(objectArray2, n5, objectArray, n, n2 - n5);
        }
    }

    MList asort(Fun fun) {
        if (this.size - this.start > 1) {
            Object[] objectArray = new Object[this.size];
            System.arraycopy(this.array, this.start, objectArray, this.start, this.size - this.start);
            MList.sort(this.array, objectArray, this.start, this.size, fun);
        }
        return this;
    }

    @Override
    public void setDefault(Fun fun) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray(Object[] objectArray) {
        System.arraycopy(this.array, this.start, objectArray, 0, this.size - this.start);
        return objectArray;
    }

    public static MList ofList(AList aList) {
        if (aList instanceof MList) {
            return (MList)aList;
        }
        return new MList(aList);
    }

    public static MList ofStrArray(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = objectArray[i] == null ? Core.UNDEF_STR : objectArray[i];
        }
        return new MList(objectArray2);
    }

    private class SubList
    extends AMList {
        Object first;

        private SubList(int n) {
            this.first = MList.this.array[n];
            this.start = n;
        }

        @Override
        public Object first() {
            return this.start < MList.this.size ? MList.this.array[this.start] : this.first;
        }

        @Override
        public AList rest() {
            int n = this.start + 1;
            return n < MList.this.size ? new SubList(n) : null;
        }

        @Override
        public AIter next() {
            int n = this.start + 1;
            return n < MList.this.size ? new Iter(n) : null;
        }

        @Override
        public boolean isEmpty() {
            return this.start >= MList.this.size;
        }

        @Override
        int _size() {
            return MList.this.size;
        }

        @Override
        Object[] array() {
            return MList.this.array;
        }

        @Override
        public AList take(int n, int n2) {
            if (n < 0) {
                n = 0;
            }
            n += this.start;
            if (n2 < 0) {
                return n < MList.this.size ? (n == this.start ? this : new SubList(n)) : null;
            }
            if ((n2 += this.start) > MList.this.size) {
                n2 = MList.this.size;
            }
            MList mList = new MList(MList.this.array);
            mList.start = n;
            mList.size = n2;
            return mList;
        }

        @Override
        public AList find(Fun fun) {
            int n = MList.this.size;
            for (int i = this.start; i < n; ++i) {
                if (fun.apply(MList.this.array[i]) != Boolean.TRUE) continue;
                return new SubList(i);
            }
            return null;
        }
    }

    private class Iter
    extends AIter
    implements Serializable {
        private int i;

        private Iter(int n) {
            this.i = n;
        }

        @Override
        public Object first() {
            if (this.i >= MList.this.size) {
                throw new IllegalStateException("End of list reached or list has shrunken.");
            }
            return MList.this.array[this.i];
        }

        @Override
        public AIter next() {
            return ++this.i < MList.this.size ? this : null;
        }

        @Override
        public boolean isEmpty() {
            return this.i >= MList.this.size;
        }

        @Override
        public AIter dup() {
            return new Iter(this.i);
        }

        @Override
        AIter write(OutputStream outputStream) throws IOException {
            if (this.i < MList.this.size) {
                byte[] byArray = new byte[MList.this.size - this.i];
                int n = this.i;
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = ((Number)MList.this.array[i + n]).byteValue();
                }
                outputStream.write(byArray);
            }
            return null;
        }
    }
}

