/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import yeti.lang.BigNum;
import yeti.lang.Core;
import yeti.lang.IntNum;
import yeti.lang.RatNum;

public abstract class Num
extends Number
implements Comparable {
    private static final long[] SHL_LIMIT = new long[]{Long.MAX_VALUE, 0x4000000000000000L, 0x2000000000000000L, 0x1000000000000000L, 0x800000000000000L, 0x400000000000000L, 0x200000000000000L, 0x100000000000000L, 0x80000000000000L, 0x40000000000000L, 0x20000000000000L, 0x10000000000000L, 0x8000000000000L, 0x4000000000000L, 0x2000000000000L, 0x1000000000000L, 0x800000000000L, 0x400000000000L, 0x200000000000L, 0x100000000000L, 0x80000000000L, 0x40000000000L, 0x20000000000L, 0x10000000000L, 0x8000000000L, 0x4000000000L, 0x2000000000L, 0x1000000000L, 0x800000000L, 0x400000000L, 0x200000000L, 0x100000000L, 0x80000000L, 0x40000000L, 0x20000000L, 0x10000000L, 0x8000000L, 0x4000000L, 0x2000000L, 0x1000000L, 0x800000L, 0x400000L, 0x200000L, 0x100000L, 524288L, 262144L, 131072L, 65536L, 32768L, 16384L, 8192L, 4096L, 2048L, 1024L, 512L, 256L, 128L, 64L, 32L, 16L, 8L, 4L, 2L, 1L};

    public abstract Num add(Num var1);

    public abstract Num add(long var1);

    public abstract Num add(RatNum var1);

    public abstract Num add(BigInteger var1);

    public abstract Num mul(Num var1);

    public abstract Num mul(long var1);

    public abstract Num mul(RatNum var1);

    public abstract Num mul(BigInteger var1);

    public abstract Num div(Num var1);

    public abstract Num div(long var1);

    public abstract Num divFrom(long var1);

    public abstract Num divFrom(RatNum var1);

    public abstract Num intDiv(Num var1);

    public abstract Num intDiv(int var1);

    public abstract Num intDivFrom(long var1);

    public abstract Num intDivFrom(BigInteger var1);

    public abstract Num rem(Num var1);

    public abstract Num rem(int var1);

    public abstract Num remFrom(long var1);

    public abstract Num remFrom(BigInteger var1);

    public abstract Num sub(Num var1);

    public abstract Num sub(long var1);

    public abstract Num subFrom(long var1);

    public abstract Num subFrom(RatNum var1);

    public abstract Num subFrom(BigInteger var1);

    public abstract Num and(Num var1);

    public abstract Num and(BigInteger var1);

    public abstract Num or(Num var1);

    public abstract Num or(long var1);

    public abstract Num xor(Num var1);

    public abstract Num xor(long var1);

    public abstract int rCompare(long var1);

    public abstract int rCompare(RatNum var1);

    public abstract int rCompare(BigInteger var1);

    public Num shl(int n) {
        long l2;
        long l3;
        if (n < 0) {
            return new IntNum(this.longValue() >>> -n);
        }
        if (n < 32 && (l3 = this.longValue()) < (l2 = SHL_LIMIT[n]) && l3 > -l2) {
            return new IntNum(l3 << n);
        }
        return new BigNum(this.toBigInteger().shiftLeft(n));
    }

    public boolean equals(Object object) {
        return object instanceof Num && this.compareTo(object) == 0;
    }

    public String toString(int n, int n2) {
        return Long.toString(this.longValue(), n);
    }

    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.longValue());
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.toString());
    }

    public static Num parseNum(String string2) {
        return Core.parseNum(string2);
    }
}

