/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.lang.reflect.Array;
import yeti.lang.AIter;
import yeti.lang.AList;
import yeti.lang.BooleanArray;
import yeti.lang.ByteArray;
import yeti.lang.CharArray;
import yeti.lang.FloatArray;
import yeti.lang.IntNum;
import yeti.lang.LList;

public class PArray
extends LList {
    int start;
    final int length;
    final Object array;
    private boolean iter;

    PArray(int n, int n2, Object object) {
        super(null, null);
        this.start = n;
        this.length = n2;
        this.array = object;
    }

    @Override
    public Object first() {
        return new IntNum(Array.getLong(this.array, this.start));
    }

    @Override
    public AIter next() {
        if (this.iter) {
            return ++this.start >= this.length ? null : this;
        }
        PArray pArray = (PArray)this.rest();
        if (pArray != null) {
            pArray.iter = true;
        }
        return pArray;
    }

    @Override
    public AIter dup() {
        PArray pArray = this.slice(this.start, this.length);
        pArray.iter = true;
        return pArray;
    }

    PArray slice(int n, int n2) {
        return new PArray(n, n2, this.array);
    }

    @Override
    public AList rest() {
        int n = this.start + 1;
        return n >= this.length ? null : this.slice(n, this.length);
    }

    @Override
    public AList take(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0 || (n2 += (n += this.start)) > this.length) {
            n2 = this.length;
        }
        if (n >= n2) {
            return null;
        }
        if (n == this.start && n2 == this.length) {
            return this;
        }
        return this.slice(n, n2);
    }

    @Override
    public long length() {
        return this.length - this.start;
    }

    public static AList wrap(byte[] byArray) {
        return byArray == null || byArray.length == 0 ? null : new ByteArray(0, byArray.length, byArray);
    }

    public static AList wrap(short[] sArray) {
        return sArray == null || sArray.length == 0 ? null : new PArray(0, sArray.length, sArray);
    }

    public static AList wrap(int[] nArray) {
        return nArray == null || nArray.length == 0 ? null : new PArray(0, nArray.length, nArray);
    }

    public static AList wrap(long[] lArray) {
        return lArray == null || lArray.length == 0 ? null : new PArray(0, lArray.length, lArray);
    }

    public static AList wrap(float[] fArray) {
        return fArray == null || fArray.length == 0 ? null : new FloatArray(0, fArray.length, fArray);
    }

    public static AList wrap(double[] dArray) {
        return dArray == null || dArray.length == 0 ? null : new FloatArray(0, dArray.length, dArray);
    }

    public static AList wrap(boolean[] blArray) {
        return blArray == null || blArray.length == 0 ? null : new BooleanArray(0, blArray.length, blArray);
    }

    public static AList wrap(char[] cArray) {
        return cArray == null || cArray.length == 0 ? null : new CharArray(0, cArray.length, cArray);
    }
}

