/*
 * Decompiled with CFR 0.152.
 */
package yeti.lang;

import java.math.BigInteger;
import yeti.lang.BigNum;
import yeti.lang.FloatNum;
import yeti.lang.IntNum;
import yeti.lang.Num;

public final class RatNum
extends Num {
    private final long numerator;
    private final long denominator;

    public RatNum(int n, int n2) {
        if (n2 == 0) {
            throw new IllegalArgumentException(n + "/0");
        }
        if (n2 < 0) {
            this.numerator = -((long)n);
            this.denominator = -((long)n2);
        } else {
            this.numerator = n;
            this.denominator = n2;
        }
    }

    private RatNum(long l2, long l3) {
        this.numerator = l2;
        this.denominator = l3;
    }

    @Override
    public Num add(Num num) {
        return num.add(this);
    }

    private static long gcd(long l2, long l3) {
        while (l3 != 0L) {
            long l4 = l3;
            l3 = l2 % l4;
            l2 = l4;
        }
        return l2;
    }

    @Override
    public Num add(long l2) {
        long l3;
        if (l2 > Integer.MAX_VALUE || l2 < -2147483647L || (l3 = l2 * this.denominator) > 0x7FFFFFFF7FFFFFFFL || l3 < -9223372034707292159L) {
            return new FloatNum((double)this.numerator / (double)this.denominator + (double)l2);
        }
        long l4 = l3 + this.numerator;
        if (l4 > Integer.MAX_VALUE || l4 < -2147483647L) {
            long l5 = RatNum.gcd(l4 < 0L ? -l4 : l4, this.denominator);
            long l6 = this.denominator / l5;
            if ((l4 /= l5) > Integer.MAX_VALUE || l4 < -2147483647L) {
                return new FloatNum((double)l4 / (double)l6);
            }
            return new RatNum(l4, l6);
        }
        return new RatNum(l4, this.denominator);
    }

    @Override
    public Num add(RatNum ratNum) {
        long l2 = this.numerator * ratNum.denominator;
        long l3 = ratNum.numerator * this.denominator;
        if (l3 > 0L ? l3 > 0x3FFFFFFFFFFFFFFFL || l2 > 0x3FFFFFFFFFFFFFFFL : l3 < -4611686018427387903L || l2 < -4611686018427387903L) {
            return new FloatNum((double)this.numerator / (double)this.denominator + (double)ratNum.numerator / (double)ratNum.denominator);
        }
        long l4 = this.denominator * ratNum.denominator;
        long l5 = l3 + l2;
        if (l5 > Integer.MAX_VALUE || l5 < -2147483647L || l4 > 0x7FFFFFFFFL || l4 < -2147483647L) {
            long l6 = RatNum.gcd(l5 < 0L ? -l5 : l5, l4);
            if ((l5 /= l6) > Integer.MAX_VALUE || l5 < -2147483647L || (l4 /= l6) > Integer.MAX_VALUE || l4 < -2147483647L) {
                return new FloatNum((double)l5 / (double)l4);
            }
        }
        return new RatNum(l5, l4);
    }

    @Override
    public Num add(BigInteger bigInteger) {
        return new FloatNum((double)this.numerator / (double)this.denominator + bigInteger.doubleValue());
    }

    @Override
    public Num mul(Num num) {
        return num.mul(this);
    }

    @Override
    public Num mul(long l2) {
        if (l2 > Integer.MAX_VALUE || l2 < -2147483647L) {
            return new FloatNum((double)this.numerator / (double)this.denominator * (double)l2);
        }
        long l3 = this.numerator * l2;
        if (l3 > Integer.MAX_VALUE || l3 < -2147483647L) {
            long l4 = RatNum.gcd(l3, this.denominator);
            long l5 = this.denominator / l4;
            if ((l3 /= l4) > Integer.MAX_VALUE || l3 < -2147483647L) {
                return new FloatNum((double)l3 / (double)l5);
            }
            return new RatNum(l3, l5);
        }
        return new RatNum(l3, this.denominator);
    }

    @Override
    public Num mul(RatNum ratNum) {
        long l2 = this.denominator * ratNum.denominator;
        long l3 = this.numerator * ratNum.numerator;
        if (l3 > Integer.MAX_VALUE || l3 < -2147483647L || l2 > Integer.MAX_VALUE || l2 < -2147483647L) {
            long l4 = RatNum.gcd(l3, l2);
            if ((l3 /= l4) > Integer.MAX_VALUE || l3 < -2147483647L || (l2 /= l4) > Integer.MAX_VALUE || l2 < -2147483647L) {
                return new FloatNum((double)l3 / (double)l2);
            }
        }
        return new RatNum(l3, l2);
    }

    @Override
    public Num mul(BigInteger bigInteger) {
        return new FloatNum((double)this.numerator / (double)this.denominator * bigInteger.doubleValue());
    }

    @Override
    public Num div(Num num) {
        return num.divFrom(this);
    }

    @Override
    public Num div(long l2) {
        if (l2 > Integer.MAX_VALUE || l2 < -2147483647L) {
            return new FloatNum((double)this.numerator / ((double)this.denominator * (double)l2));
        }
        long l3 = this.denominator * l2;
        if (l3 > Integer.MAX_VALUE || l3 < -2147483647L) {
            long l4 = RatNum.gcd(l3, this.numerator);
            long l5 = this.numerator / l4;
            if ((l3 /= l4) > Integer.MAX_VALUE || l3 < -2147483647L) {
                return new FloatNum((double)l5 / (double)l3);
            }
            return new RatNum(l5, l3);
        }
        return new RatNum(this.numerator, l3);
    }

    @Override
    public Num divFrom(long l2) {
        if (l2 > Integer.MAX_VALUE || l2 < -2147483647L) {
            return new FloatNum((double)l2 / (double)this.numerator * (double)this.denominator);
        }
        long l3 = this.denominator * l2;
        if (l3 > Integer.MAX_VALUE || l3 < -2147483647L) {
            long l4 = RatNum.gcd(l3, this.numerator);
            long l5 = this.numerator / l4;
            if ((l3 /= l4) > Integer.MAX_VALUE || l3 < -2147483647L) {
                return new FloatNum((double)l3 / (double)l5);
            }
            return new RatNum(l3, l5);
        }
        return new RatNum(l3, this.numerator);
    }

    @Override
    public Num divFrom(RatNum ratNum) {
        long l2 = this.numerator * ratNum.denominator;
        long l3 = this.denominator * ratNum.numerator;
        if (l3 > Integer.MAX_VALUE || l3 < -2147483647L || l2 > Integer.MAX_VALUE || l2 < -2147483647L) {
            long l4 = RatNum.gcd(l3, l2);
            if ((l3 /= l4) > Integer.MAX_VALUE || l3 < -2147483647L || (l2 /= l4) > Integer.MAX_VALUE || l2 < -2147483647L) {
                return new FloatNum((double)l3 / (double)l2);
            }
        }
        return new RatNum(l3, l2);
    }

    @Override
    public Num intDiv(Num num) {
        return num.intDivFrom(this.numerator / this.denominator);
    }

    @Override
    public Num intDiv(int n) {
        return new IntNum(this.numerator / this.denominator / (long)n);
    }

    @Override
    public Num intDivFrom(long l2) {
        return new IntNum(l2 / (this.numerator / this.denominator));
    }

    @Override
    public Num intDivFrom(BigInteger bigInteger) {
        return new BigNum(bigInteger.divide(BigInteger.valueOf(this.numerator / this.denominator)));
    }

    @Override
    public Num rem(Num num) {
        return num.remFrom(this.numerator / this.denominator);
    }

    @Override
    public Num rem(int n) {
        return new IntNum(this.numerator / this.denominator % (long)n);
    }

    @Override
    public Num remFrom(long l2) {
        return new IntNum(l2 % (this.numerator / this.denominator));
    }

    @Override
    public Num remFrom(BigInteger bigInteger) {
        return new BigNum(bigInteger.remainder(BigInteger.valueOf(this.numerator / this.denominator)));
    }

    @Override
    public Num sub(Num num) {
        return num.subFrom(this);
    }

    @Override
    public Num sub(long l2) {
        return this.add(-l2);
    }

    @Override
    public Num subFrom(long l2) {
        long l3;
        if (l2 > Integer.MAX_VALUE || l2 < -2147483647L || (l3 = l2 * this.denominator) > 0x7FFFFFFF7FFFFFFFL || l3 < -9223372034707292159L) {
            return new FloatNum((double)l2 - (double)this.numerator / (double)this.denominator);
        }
        long l4 = l3 - this.numerator;
        if (l4 > Integer.MAX_VALUE || l4 < -2147483647L) {
            long l5 = RatNum.gcd(l4 < 0L ? -l4 : l4, this.denominator);
            long l6 = this.denominator / l5;
            if ((l4 /= l5) > Integer.MAX_VALUE || l4 < -2147483647L) {
                return new FloatNum((double)l4 / (double)l6);
            }
            return new RatNum(l4, l6);
        }
        return new RatNum(l4, this.denominator);
    }

    @Override
    public Num subFrom(RatNum ratNum) {
        long l2 = this.numerator * ratNum.denominator;
        long l3 = ratNum.numerator * this.denominator;
        if (l3 > 0L ? l3 > 0x3FFFFFFFFFFFFFFFL || l2 < -4611686018427387903L : l3 < -4611686018427387903L || l2 > 0x3FFFFFFFFFFFFFFFL) {
            return new FloatNum((double)this.numerator / (double)this.denominator + (double)ratNum.numerator / (double)ratNum.denominator);
        }
        long l4 = this.denominator * ratNum.denominator;
        long l5 = l3 - l2;
        if (l5 > Integer.MAX_VALUE || l5 < -2147483647L || l4 > 0x7FFFFFFFFL || l4 < -2147483647L) {
            long l6 = RatNum.gcd(l5 < 0L ? -l5 : l5, l4);
            if ((l5 /= l6) > Integer.MAX_VALUE || l5 < -2147483647L || (l4 /= l6) > Integer.MAX_VALUE || l4 < -2147483647L) {
                return new FloatNum((double)l5 / (double)l4);
            }
        }
        return new RatNum(l5, l4);
    }

    @Override
    public Num and(Num num) {
        return new IntNum(num.longValue() & this.numerator / this.denominator);
    }

    @Override
    public Num and(BigInteger bigInteger) {
        return new IntNum(bigInteger.longValue() & this.numerator / this.denominator);
    }

    @Override
    public Num or(Num num) {
        return num.or(this.numerator / this.denominator);
    }

    @Override
    public Num or(long l2) {
        return new IntNum(l2 | this.numerator / this.denominator);
    }

    @Override
    public Num xor(Num num) {
        return num.xor(this.numerator / this.denominator);
    }

    @Override
    public Num xor(long l2) {
        return new IntNum(l2 ^ this.numerator / this.denominator);
    }

    public RatNum reduce() {
        long l2 = RatNum.gcd(this.numerator, this.denominator);
        return new RatNum(this.numerator / l2, this.denominator / l2);
    }

    @Override
    public byte byteValue() {
        return (byte)(this.numerator / this.denominator);
    }

    @Override
    public short shortValue() {
        return (short)(this.numerator / this.denominator);
    }

    @Override
    public int intValue() {
        return (int)(this.numerator / this.denominator);
    }

    @Override
    public long longValue() {
        return this.numerator / this.denominator;
    }

    @Override
    public float floatValue() {
        return (float)((double)this.numerator / (double)this.denominator);
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public static Num div(long l2, long l3) {
        if (l3 == 0L) {
            throw new IllegalArgumentException("division by zero");
        }
        if (l2 > Integer.MAX_VALUE || l2 < -2147483647L || l3 > Integer.MAX_VALUE || l3 < -2147483647L) {
            long l4 = RatNum.gcd(l2, l3);
            if ((l2 /= l4) > Integer.MAX_VALUE || l2 < -2147483647L || (l3 /= l4) > Integer.MAX_VALUE || l3 < -2147483647L) {
                return new FloatNum((double)l2 / (double)l3);
            }
        }
        return l3 < 0L ? new RatNum(-l2, -l3) : new RatNum(l2, l3);
    }

    @Override
    public Num subFrom(BigInteger bigInteger) {
        return new FloatNum((double)this.numerator / (double)this.denominator - bigInteger.doubleValue());
    }

    public int numerator() {
        return (int)this.numerator;
    }

    public int denominator() {
        return (int)this.denominator;
    }

    public int compareTo(Object object) {
        return ((Num)object).rCompare(this);
    }

    @Override
    public int rCompare(long l2) {
        if (-2147483647L <= l2 && l2 <= Integer.MAX_VALUE) {
            long l3 = l2 * this.denominator;
            return this.numerator < l3 ? 1 : (this.numerator > l3 ? -1 : 0);
        }
        return (double)this.numerator / (double)this.denominator < (double)l2 ? 1 : -1;
    }

    @Override
    public int rCompare(RatNum ratNum) {
        long l2 = this.numerator * ratNum.denominator;
        long l3 = ratNum.numerator * this.denominator;
        return l2 < l3 ? 1 : (l2 > l3 ? -1 : 0);
    }

    @Override
    public int rCompare(BigInteger bigInteger) {
        if (this.numerator % this.denominator == 0L && BigInteger.valueOf(this.numerator / this.denominator).equals(bigInteger)) {
            return 0;
        }
        double d2 = (double)this.numerator / (double)this.denominator;
        double d3 = bigInteger.doubleValue();
        return d2 < d3 ? 1 : (d2 > d3 ? -1 : 0);
    }

    public String toString() {
        if (this.numerator % this.denominator == 0L) {
            return Integer.toString((int)this.numerator / (int)this.denominator);
        }
        return Double.toString((double)this.numerator / (double)this.denominator);
    }

    public int hashCode() {
        long l2 = this.numerator / this.denominator;
        long l3 = Double.doubleToLongBits((double)this.numerator / (double)this.denominator - (double)l2);
        if (l3 != Long.MIN_VALUE) {
            l2 ^= l3;
        }
        return (int)(l2 ^ l2 >>> 32);
    }
}

